/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.action.invokers;

import com.floragunn.codova.config.temporal.DurationExpression;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.script.types.SignalsObjectFunctionScript;
import com.floragunn.signals.support.InlinePainlessScript;
import com.floragunn.signals.watch.action.handlers.ActionHandler;
import com.floragunn.signals.watch.action.invokers.ActionInvoker;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.severity.SeverityLevel;
import com.floragunn.signals.watch.severity.SeverityMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class AlertAction
extends ActionInvoker {
    protected final DurationExpression throttlePeriod;
    protected final SeverityLevel.Set severityLevels;
    protected final boolean ackEnabled;

    public AlertAction(String name, ActionHandler handler, DurationExpression throttlePeriod, SeverityLevel.Set severityLevels, List<Check> checks, InlinePainlessScript<SignalsObjectFunctionScript.Factory> foreach, Integer foreachLimit, boolean ackEnabled) {
        super(name, handler, checks, foreach, foreachLimit);
        this.throttlePeriod = throttlePeriod;
        this.severityLevels = severityLevels;
        this.ackEnabled = ackEnabled;
    }

    public DurationExpression getThrottlePeriod() {
        return this.throttlePeriod;
    }

    public SeverityLevel.Set getSeverityLevels() {
        return this.severityLevels;
    }

    public boolean isAckEnabled() {
        return this.ackEnabled;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", this.handler.getType());
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.severityLevels != null) {
            builder.field("severity", (ToXContent)this.severityLevels);
        }
        if (this.throttlePeriod != null) {
            builder.field("throttle_period", this.throttlePeriod.toString());
        }
        if (this.foreach != null) {
            builder.field("foreach", (ToXContent)this.foreach);
        }
        if (this.foreachLimit != 100) {
            builder.field("foreach_limit", this.foreachLimit);
        }
        if (this.checks != null && this.checks.size() > 0) {
            builder.field("checks").startArray();
            for (Check check : this.checks) {
                check.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (!this.ackEnabled) {
            builder.field("ack_enabled", false);
        }
        this.handler.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static AlertAction create(WatchInitializationService watchInitService, DocNode jsonObject, SeverityMapping severityMapping) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonObject, validationErrors);
        String name = vJsonNode.get("name").required().asString();
        List<Check> checks = AlertAction.createNestedChecks(watchInitService, vJsonNode, validationErrors);
        DurationExpression throttlePeriod = (DurationExpression)vJsonNode.get("throttle_period").byString(DurationExpression::parse);
        SeverityLevel.Set severityLevels = null;
        ActionHandler handler = null;
        Integer foreachLimit = null;
        boolean ackEnabled = true;
        try {
            severityLevels = SeverityLevel.Set.createWithNoneDisallowed(vJsonNode.get("severity").asAnything());
            if (severityLevels != null) {
                AlertAction.validateSeverityLevelsAgainstSeverityMapping(severityLevels, severityMapping);
            }
        }
        catch (ConfigValidationException e) {
            validationErrors.add("severity", e);
        }
        try {
            handler = ActionHandler.create(watchInitService, vJsonNode);
        }
        catch (ConfigValidationException e) {
            validationErrors.add(null, e);
        }
        InlinePainlessScript foreach = (InlinePainlessScript)vJsonNode.get("foreach").byString(s -> InlinePainlessScript.parse(s, SignalsObjectFunctionScript.CONTEXT, watchInitService));
        foreachLimit = vJsonNode.get("foreach_limit").asInteger();
        ackEnabled = vJsonNode.get("ack_enabled").withDefault(true).asBoolean();
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return new AlertAction(name, handler, throttlePeriod, severityLevels, checks, foreach, foreachLimit, ackEnabled);
    }

    public static List<AlertAction> createFromArray(WatchInitializationService ctx, List<DocNode> arrayNode, SeverityMapping severityMapping) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ArrayList<AlertAction> result = new ArrayList<AlertAction>(arrayNode.size());
        for (DocNode member : arrayNode) {
            if (!member.isMap()) continue;
            try {
                result.add(AlertAction.create(ctx, member, severityMapping));
            }
            catch (ConfigValidationException e) {
                validationErrors.add(member.hasNonNull("name") ? "[" + member.get("name") + "]" : "[]", e);
            }
        }
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    private static void validateSeverityLevelsAgainstSeverityMapping(SeverityLevel.Set severityLevels, SeverityMapping severityMapping) throws ConfigValidationException {
        if (severityMapping == null) {
            throw new ConfigValidationException(new ValidationError(null, "Severity can only be used in actions with a defined severity mapping"));
        }
        Set<SeverityLevel> definedLevels = severityMapping.getDefinedLevels();
        if (!severityLevels.isSubsetOf(definedLevels)) {
            throw new ConfigValidationException(new ValidationError(null, "Uses a severity which is not defined by severity mapping: " + severityLevels.missingFromOther(definedLevels)));
        }
    }
}

